// $Id: CTextIO.cpp,v 1.2 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CTextIO.hpp"
#include <fstream>

using Exponent::IO::CTextIO;
using std::ifstream;
using std::ofstream;
using std::ios;
using std::endl;

//	===========================================================================
bool CTextIO::readFile(const CSystemString &path, CString &string, const CString &endOfLineCharacter)
{
	ifstream inputFile(path.getString(), ios::in);
	if (!inputFile)
	{
		return false;
	}
	inputFile.clear();
	while(!inputFile.eof())
	{
		char str[1024];
		inputFile.getline(str, 1024, '\n');

		// Strip the M$ \r\n new line
		if (str[strlen(str) - 1] == '\r')
		{
			str[strlen(str) - 1] = '\0';
		}

		// Append to the original string
		string.appendString(str);
		string.appendString(endOfLineCharacter);
	}
	return true;
}

//	===========================================================================
bool CTextIO::readFile(const CSystemString &path, TStringCountedPointerArray &array)
{
	// Load the file
	ifstream inputFile(path.getString(), ios::in);

	// Check it is opened properly
	if (!inputFile)
	{
		return false;
	}

	// Clear previous errors
	inputFile.clear();

	// Loop and load
	while(!inputFile.eof())
	{
		// Get the inpt line
		char str[1024];
		inputFile.getline(str, 1024, '\n');

		// Strip the M$ \r\n new line
		if (str[strlen(str) - 1] == '\r')
		{
			str[strlen(str) - 1] = '\0';
		}

		// Add the element to the array
		array.addElement(new CString(str));
	}

	// Close the input file
	inputFile.close();

	// Sucess!
	return true;
}

//	===========================================================================
bool CTextIO::writeFile(const CSystemString &path, const CString &string)
{
	ofstream outFile(path.getString(), ios::trunc);
	if (!outFile)
	{
		return false;
	}

	outFile.clear();
	outFile << string.getString() << endl;
	outFile.close();

	return true;
}

//	===========================================================================
bool CTextIO::writeFile(const CSystemString &path, TStringCountedPointerArray &array)
{
	// Open the file
	ofstream outFile(path.getString(), ios::trunc);

	// If it didnt open, we failed
	if (!outFile)
	{
		return false;
	}

	// Clear any previous errors
	outFile.clear();

	// Loop over the array
	for (long i = 0; i < array.getArraySize(); i++)
	{
		// Get the string
		CString *string = array.elementAtIndex(i);

		// Check its valid
		if (string)
		{
			// We want to add the endl if we have more lines
			if (i != array.getArraySize() - 1)
			{
				outFile << string->getString() << endl;
			}
			else
			{
				outFile << string->getString();
			}
		}
	}

	// Close the file
	outFile.close();

	// We are done
	return true;
}
